require_relative "_config"

class ProviderLogin
  def initialize(driver)
    @driver = driver
  end

  def login (username, password, facility)
    wait = Selenium::WebDriver::Wait.new(:timeout => 80)

    @driver.get($acp_url + "/AuthorizationServices/logout")

    @driver.get($acp_url + "/" + $acp_app)

    wait.until { @driver.find_element(:id, "name-c").displayed? }

    @driver.find_element(:id, "name-c").send_keys username
    @driver.find_element(:id, "password").send_keys password
    @driver.find_element(:css, "input.ui-input-text.ui-body-d").send_keys facility
    sleep(3); #give time for autocomplete
    wait.until{ @driver.find_element(:css, "a[data-facility-name='" + facility + "']").displayed? }
    @driver.find_element(:css, "a[data-facility-name='" + facility + "']").click
    @driver.find_element(:id, 'loginButton').click

    # accept SUD if present
    !5.times{ 
      if (element_present?(:id, "portal-staff-user-disclaimer"))
        @driver.find_element(:id, "accept-btn").click()
        break
      end
        sleep 1
    }

  end

  def loginAsStaff01()
    login('zztest.staff01', 'pass', 'DC VAMC')
  end

  def loginAsDoc123(site)
    @site = ( defined?(site) ) ? site : 'TEST VAMC'
    login('doc123', 'doc123!!', @site)
  end

  def loginAsDoc123DC()
    login('doc123', 'doc123!!', 'DC VAMC')
  end

  def loginAsScvtest2()
    login('zztest.scvtest2', 'pass', 'TEST VAMC 3')
  end
  
  def loginAsCprs1234()
    login('cprs1234', 'cprs4321$', 'TEST VAMC 3')
  end
end
